#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define M 1000005

long long X[M];
long long H[M];
int Ind[M];
double Rez[M];
int Stog[M];

void swall(long long *a, long long *b){
    long long t=*a; *a=*b; *a=*b; *b=t;
}

void swain(int *a, int *b){
    int t=*a; *a=*b; *b=t;
}

int particija(int d, int g){
    long long p=X[g];
    int i=(d-1);
    
    for(int j=d; j<=g-1; j++){
        if(X[j]<p){
            i++;
            swall(&X[i], &X[j]);
            swall(&H[i], &H[j]);
            swain(&Ind[i], &Ind[j]);
        }
    }
    swall(&X[i+1], &X[g]);
    swall(&H[i+1], &H[g]);
    swain(&Ind[i+1], &Ind[g]);
    return (i+1);
}

void quickyyy(int d, int g){
    if(d<g){
        int pi=particija(d, g);
        quickyyy(d, pi-1);
        quickyyy(pi+1, g);
    }
}

double mind(double a, double b){
    if(a<0)return b;
    return (a<b)?a:b;
}

double d(long long xi, long long hi, long long xj, long long hj, int j_levo){
    if(j_levo){
        // Levi kanap: xi - d = x_p. Trazimo d.
        return (double)(xi-hi-(xj-hj))/2.0;
    }else{
        // Desni kanap: xi + d = x_p. Trazimo d.
        return (double)(xj+hj-(xi+hi))/2.0;
    }
}

void s(){
    int n;
    int i;
    
    if(scanf("%d",&n)!=1)return;

    for(i=0;i<n;i++){
        if(scanf("%lld",&X[i])!=1)return;
    }
    for(i=0;i<n;i++){
        if(scanf("%lld",&H[i])!=1)return;
        Ind[i]=i; 
        Rez[i]=-1.0;
    }

    quickyyy(0, n-1);

    // 1. Pretraga Levo (za h_j - x_j)
    int vrh=-1;
    for(i=0;i<n;i++){
        long long current_val=H[i]-X[i];
        
        while(vrh!=-1){
             long long j=Stog[vrh];
             long long stack_val=H[j]-X[j];
             
             // Izbacujemo j ako j ne moze bolje da posluzi
             // Logika je da j mora da ima bolji h-x nego i
             if(stack_val <= current_val){
                 vrh--;
             } else {
                 break;
             }
        }

        if(vrh!=-1){
            long long j=Stog[vrh];
            double ud=d(X[i], H[i], X[j], H[j], 1);
            
            // Provera da li je visina j dovoljna
            if(H[j]>=H[i]){
                 Rez[Ind[i]]=mind(Rez[Ind[i]], ud);
            }
        }
        
        Stog[++vrh]=i;
    }

    // 2. Pretraga Desno (za h_j + x_j)
    vrh=-1;
    for(i=n-1;i>=0;i--){
        long long current_val=H[i]+X[i];
        
        while(vrh!=-1){
            long long j=Stog[vrh];
            long long stack_val=H[j]+X[j];
            
            if(stack_val <= current_val){
                 vrh--;
            } else {
                 break;
            }
        }

        if(vrh!=-1){
            long long j=Stog[vrh];
            double ud=d(X[i], H[i], X[j], H[j], 0);
            
            // Provera da li je visina j dovoljna
            if(H[j]>=H[i]){
                Rez[Ind[i]]=mind(Rez[Ind[i]], ud);
            }
        }
        
        Stog[++vrh]=i;
    }

    for(i=0;i<n;i++){
        if(Rez[i]<0){
            printf("-1\n");
        }else{
            printf("%.1f\n",Rez[i]);
        }
    }
}

int main(){
    s();
    return 0;
}